
function [sorted, ind] = meansort(timetraces)

%%% Sorts based on maximum value of each column (cell during the recording)
%%% First cell will have lowest peak,last cell will have highest value
%%% Saves the cells order in "ind" with their initial position in
%%% "timetraces"


%%% FINDS MAX VALUE OF EACH CELL (stored in "maxeach")
ii=0;
meaneach = zeros(1,size(timetraces,2));

for ii=1:size(timetraces,2) %for all the frames
    meaneach(ii) = mean(timetraces(:,ii));
end

%%% SORTS "maxeach" AND SAVES SORTED CELLS REFERENCE IN "ind"
%%% CREATES MATRIX CONTAINING SORTED TRACES

[~, ind] = sort(meaneach);
sorted = timetraces(:,ind);

end